/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;

import jp.mosp.kintai.dto.CmRotationDto;

public class CmRotationDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE	= "CM_ROTATION";
	public static final String KEY_1	= "KCODE";			//ЈR[h
	public static final String KEY_2	= "RTCODE";			//֔ԃp^[R[h

	// 
	public static final String COL_KCODE 			= "KCODE";		//ЈR[h
	public static final String COL_RTCODE 		= "RTCODE";		//֔ԃp^[R[h
	public static final String COL_RTNAME  		= "RTNAME";		//֔ԃp^[
	public static final String COL_HOLIDAYFLAG  	= "HOLIDAYFLAG";//jՓtO
	public static final String COL_DAY1  			= "DAY1";		//1
	public static final String COL_DAY2  			= "DAY2";		//2
	public static final String COL_DAY3  			= "DAY3";		//3
	public static final String COL_DAY4  			= "DAY4";		//4
	public static final String COL_DAY5  			= "DAY5";		//5
	public static final String COL_DAY6  			= "DAY6";		//6
	public static final String COL_DAY7  			= "DAY7";		//7
	public static final String COL_DAY8  			= "DAY8";		//8
	public static final String COL_DAY9  			= "DAY9";		//9
	public static final String COL_DAY10  		= "DAY10";		//10
	public static final String COL_DELETEFLAG 	= "DELETEFLAG";	//폜tO

	/**
	 * RXgN^
	 */
	public CmRotationDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmRotationDto> mappingAll() throws SQLException {
		List<CmRotationDto> all = new ArrayList<CmRotationDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return fm_rotationDto fm_rotationR[h
	 * @throws SQLException
	 */
	private CmRotationDto mapping() throws SQLException {
		CmRotationDto dto = new CmRotationDto();
		dto.setKCode		(rs.getString (COL_KCODE));
		dto.setRtCode 		(rs.getString (COL_RTCODE  ));		//֔ԃp^[R[h
		dto.setRtName 		(rs.getString (COL_RTNAME  ));		//֔ԃp^[
		dto.setHolidayFlag 	(rs.getInt    (COL_HOLIDAYFLAG  ));	//jՓtO
		dto.setDay1 		(rs.getString (COL_DAY1  ));		//1
		dto.setDay2 		(rs.getString (COL_DAY2  ));		//2
		dto.setDay3		 	(rs.getString (COL_DAY3  ));		//3
		dto.setDay4 		(rs.getString (COL_DAY4  ));		//4
		dto.setDay5 		(rs.getString (COL_DAY5  ));		//5
		dto.setDay6 		(rs.getString (COL_DAY6  ));		//6
		dto.setDay7 		(rs.getString (COL_DAY7  ));		//7
		dto.setDay8 		(rs.getString (COL_DAY8  ));		//8
		dto.setDay9 		(rs.getString (COL_DAY9  ));		//9
		dto.setDay10 		(rs.getString (COL_DAY10  ));		//10
		dto.setDeleteFlag 	(rs.getInt    (COL_DELETEFLAG  ));	//폜tO
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param rtcode ֔ԃp^[R[h(L[)
	 * @return fm_rotationDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmRotationDto findForKey(
			String kcode,
			String rtcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, rtcode);
			executeQuery();
			CmRotationDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param rtcode ֔ԃp^[R[h(L[)
	 * @return fm_rotationDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmRotationDto findForUpdate(
			String kcode,
			String rtcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, rtcode);
			executeQuery();
			CmRotationDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmRotationDto> findForCondition(
			String kcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE  );
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		sb.append(" ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   kcode);
			executeQuery();
			List<CmRotationDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode		ЈR[h
	 * @param rtcode	[gR[h
	 * @param rtname	[g
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String kcode,
			String rtcode,
			String rtname
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		sb.append(" ");
		if (!rtcode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_RTCODE);
			sb.append(" LIKE ? ");
		}
		if (!rtname.equals("")) {
			sb.append(" AND ");
			sb.append(COL_RTNAME);
			sb.append(" LIKE ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			if (!rtcode.equals("")) {
				setParam(index++, rtcode + "%");
			}
			if (!rtname.equals("")) {
				setParam(index++, "%" + rtname + "%");
			}
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmRotationDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto,true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmRotationDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {							
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto,false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getRtCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(CmRotationDto dto,boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode());		//ЈR[h		
		setParam(index++, dto.getRtCode());		//֔ԃp^[R[h
		setParam(index++, dto.getRtName());		//֔ԃp^[
		setParam(index++, dto.getHolidayFlag());//jՓtO
		setParam(index++, dto.getDay1());		//1
		setParam(index++, dto.getDay2());		//2
		setParam(index++, dto.getDay3());		//3
		setParam(index++, dto.getDay4());		//4
		setParam(index++, dto.getDay5());		//5
		setParam(index++, dto.getDay6());		//6
		setParam(index++, dto.getDay7());		//7
		setParam(index++, dto.getDay8());		//8
		setParam(index++, dto.getDay9());		//9
		setParam(index++, dto.getDay10());		//10
		setParam(index++, dto.getDeleteFlag());	//폜tO
		setCommonParams(isInsert);
	}

}
